/**
* Script: radialmenu.js
* Written by: Radnen
* Updated: 10/29/2010
**/

function RadialMenu(parent, r)
{
	this.inherit = Control;
	this.inherit(parent, 0, 0, r, r);
	
	this.items = [];
	this.backImage = null;
	this.r = r; // radius
	this.active = false;
	this.onHide = new Event(this);
	
	this.show = function(x, y) {
		if (!x || !y) { x = Cursor.x; y = Cursor.y; }
		this.x = x;
		this.y = y;
		this.active = true;
	}
	
	this.hide = function() {
		this.active = false;
		this.onHide.execute();
	}
	
	this.draw = function() {
		if (!this.active) return;
		if (this.backImage != null) {
			var x = this.x - this.backImage.width/2;
			var y = this.y - this.backImage.height/2;
			this.backImage.blit(x, y);
		}
		
		var delta = (2*Math.PI)/this.items.length;
		for(var i = 0; i < this.items.length; ++i) {
			var x = this.x-this.items[i].image.width/2+Math.cos(i*delta)*this.r;
			var y = this.y-this.items[i].image.height/2+Math.sin(i*delta)*this.r;
			var cur_within = Cursor.isWithin(x, y, this.r, this.r);
			if (cur_within) {
				var r = this.items[i].image.width/2;
				FilledCircle(x+r, y+r, r, Colors.clearBlack);
				if (Cursor.onLeftUp()) this.items[i].callback();
			}
			this.items[i].image.blit(x, y);
			if (Cursor.onLeftUp() || Cursor.onRightClick()) this.hide();
		}
		
		for (var i = 0; i < this.items.length; ++i) {
			var x = this.x-this.items[i].image.width/2+Math.cos(i*delta)*this.r;
			var y = this.y-this.items[i].image.height/2+Math.sin(i*delta)*this.r;
			var cur_within = Cursor.isWithin(x, y, this.r, this.r);
			if (cur_within) {
				System.basicWindow.drawWindow(x+this.r, y-this.r, System.textFont.getStringWidth(this.items[i].text), System.textFont.getHeight());
				System.textFont.drawText(x+this.r, y-this.r, this.items[i].text);
			}
		}
	}
	
	this.addItem = function(text, image, callback) {
		this.items.push({text: text, image: image, callback: callback});
	}	
}